
import { BasicContainer } from '/sd:basic-container.js'; 

/**
 * class to create instance of Button. It allows for define button with label text inside div container, and to invoke action onclick div container. It creates effect of clicked and non clicked button.
 */
export class ActionButton extends BasicContainer {	
	/**
	 * Constructor
	 * @param    {jQuery} xmlObject    		Data loaded from XML
	 * @param    {String} parentId    		HTML ID of the object, which has to be a parent of constructing object
	 * @param	 {String} clickAction		This value is insert inside of onclck="" attribute of HTML button 
	 * @param    {Integer} itemNumber   	Number of object constructing item - if it is null, it means, that item is not numerable
	 * @param    {String} pointMainClass    Name of the CSS style's class
	 * @param    {String} objId    			ID of creating object - if itemNumber is not null, then itemNumber will be suffix of the ID
	 * @param    {Boolean} standalone   	It specifies if Container is simple (false) or referenced with object defined in XML file(true)
	 */
	constructor(xmlObject, parentId, clickAction, itemNumber = null, pointMainClass = "ActionButton", objId = null, standalone = false) {
		super(xmlObject, parentId, pointMainClass, itemNumber, objId, standalone);
		if(itemNumber == null)
			itemNumber = 0;
		if(standalone) {
			this.id = objId;
		}
		else if(xmlObject[itemNumber].localName == "logoutbutton") {
			this.id = "logoutButton";
		}
		else if(xmlObject[itemNumber].localName == "addeventbutton") {
			this.id = "addEventButton";
		}
		else {
			this.id = "button" + String(itemNumber + 1);
		}
		this.mainObj.setAttribute("onclick", clickAction);
		this.mainObj.setAttribute("id", this.id);
		if(!standalone)
			this.readAllStylesFromAttributes(xmlObject[itemNumber].attributes);
		//create button label
		this.textObj = "";
		this.textObj = document.createElement("span");
		this.textObj.setAttribute("id", this.id + "Label");
		this.textObj.setAttribute("class", "ActionButtonText");
		this.mainObj.appendChild(this.textObj);
		this.setLabelText((standalone || xmlObject == null) ? "" : xmlObject[itemNumber].attributes['label'].value);
		this.createThemeSchema();
	}
	
	/**
	 * Creates object in HTML file - adjusted to work with ActionButton
	 * @override Method in BasicContainer
	 * @param {jQuery} attributes 		Attributes of choosen markup read from XML file
	 */
	createObject(attributes) {
		//create button container
		this.mainObj = document.createElement("div");
		this.mainObj.setAttribute("autocomplete", "off");
		this.parentObj.appendChild(this.mainObj);
	}
	
	/**
	 * Sets text to the HTML object related to instance of ActionButton
	 * @param {String} text 	Text to set
	 */
	setLabelText(text) {
		this.textObj.innerHTML = text;
	}
}